---- Run first: Create the res HVAC weighted version of the annual results by summing the results of the previous table
--  Add the results to the measure impacts table

SET search_path TO "MC_results_database";
DROP TABLE IF EXISTS meas_impacts_hvacwtd;
CREATE TABLE meas_impacts_hvacwtd AS 

SELECT
"EnergyImpactID",
'DEER2020'::VARCHAR as "Version",
'D20v0'::VARCHAR as "VersionSource",
date_trunc('second', now()) as "LastMod",
"PA",
"BldgType"::VARCHAR,
"BldgVint"::VARCHAR,
"BldgLoc"::VARCHAR,
'rWtd'::VARCHAR AS "BldgHVAC", --note single quote defines a new string name, double quote refer to column name 
"NormUnit"::VARCHAR,
--apply multiplied weights to all numeric parameters
(Sum("NumUnit") / Sum(wt_hvac))::numeric(15,5) AS "NumUnit",
(Sum("MeasArea") / Sum(wt_hvac))::numeric(15,1) AS "MeasArea",
"ScaleBasis"::VARCHAR,
(Sum("APreWBkWh") / Sum(wt_hvac))::numeric(15,5) as "APreWBkWh",
(Sum("APreWBkW") / Sum(wt_hvac))::numeric(15,5) as "APreWBkW",
(Sum("APreWBtherm") / Sum(wt_hvac))::numeric(15,5) as "APreWBtherm",
(Sum("AStdWBkWh") / Sum(wt_hvac))::numeric(15,5) as "AStdWBkWh",
(Sum("AStdWBkW") / Sum(wt_hvac))::numeric(15,5) as "AStdWBkW",
(Sum("AStdWBtherm") / Sum(wt_hvac))::numeric(15,5) as "AStdWBtherm"
from meas_impacts_hvactmp
GROUP BY
"EnergyImpactID",
"PA",
"BldgType",
"BldgVint",
"BldgLoc",
"NormUnit",
"ScaleBasis"
ORDER BY 
"EnergyImpactID",
"PA",
"BldgType",
"BldgVint",
"BldgLoc";

---creates BldgHVAC = "rWtd" entries only
---
---then Run second: insert into existing measure impacts results below
---after this step, THEN apply PA=Any script

SET search_path TO "MC_results_database";
DROP TABLE IF EXISTS meas_impacts_2020_res_new;
create table meas_impacts_2020_res_new as (select * from meas_impacts_2020_reshvac);

INSERT INTO meas_impacts_2020_res_new
SELECT
*
FROM meas_impacts_hvacwtd

ORDER BY 
"EnergyImpactID",
"PA",
"BldgType",
"BldgVint",
"BldgLoc",
"BldgHVAC";